// ==UserScript==
// @name         5ch 投稿フォーム拡張（右ダブルクリックで表示）
// @namespace    http://tampermonkey.net/
// @version      1.5
// @description  投稿フォームにsage保持、透過、右寄せ、Ctrl+Enter送信、サイズ可変機能を追加
// @author       GPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';
    if (window.top !== window.self) return;

    const style = document.createElement('style');
style.textContent = `
    :root {
        --bg-dark: #212425;
        --bg-darker: #1e1e1e;
        --bg-darkest: #1a1a1a;
        --text-main: #e0e0e0;
        --text-muted: #aabbcc;
        --text-link: #80cbc4;
        --text-link-hover: #a7ffeb;
        --border-color: #333;
        --white: #ffffff;
    }

.formbox {
    background-color: var(--bg-dark);
    color: var(--text-main);
    border: 1px solid var(--border-color);
    border-radius: 6px;
    padding: 10px;
    box-shadow: 0 5px 10px rgba(0,0,0,0.4);
    position: fixed;
    left: 6px;
    bottom: 150px; /* ボックスの下からの表示位置 */
    /* transform 削除 */
    z-index: 9999;
    width: 310px;
    height: 454px;
    max-width: 95vw;
    cursor: move;
    opacity: 0.9;
    resize: both;
    overflow: hidden;
    display: flex;
    flex-direction: column;
}

    .formbody {
        flex: 1 1 auto;
        display: flex;
        flex-direction: column;
        overflow: hidden; /* ここもoverflow隠す */
        min-height: 100px;
        gap: 8px;
    }

    /* form全体を親の高さに追従させる */
    .formbody form {
        display: flex;
        flex-direction: column;
        height: 100%;
    }

    .formbox input,
    .formbox textarea {
        background-color: var(--bg-darker);
        color: var(--text-main);
        border: 1px solid var(--border-color);
        border-radius: 4px;
        padding: 5px;
        margin: 4px 0;
        box-sizing: border-box;
    }

    .formbox textarea {
        flex: 1 1 auto;
        width: 100%;
        resize: none;
        min-height: 100px;
        overflow-y: auto; /* 縦スクロール可能 */
    }

    .formheader {
        font-weight: bold;
        color: var(--white);
        margin-bottom: 5px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: move;
    }

    .formheader .left {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .sage-label {
        font-weight: normal;
        font-size: 0.9em;
        user-select: none;
        cursor: pointer;
        color: var(--text-muted);
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .permanent-label {
        font-weight: normal;
        font-size: 0.9em;
        user-select: none;
        cursor: pointer;
        color: var(--text-muted);
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .close-btn {
        background: none;
        border: none;
        color: var(--text-muted);
        font-size: 1.2em;
        cursor: pointer;
    }

    .submitbtn, .oekaki_load1, .clearbtn {
        background-color: var(--bg-darker);
        color: var(--text-main);
        border: 1px solid var(--border-color);
        padding: 6px 12px;
        cursor: pointer;
    }

    .submitbtn:hover, .oekaki_load1:hover, .clearbtn:hover, .close-btn:hover {
        background-color: var(--bg-darkest);
    }

    .button-row {
        flex-shrink: 0;
        margin-top: 8px;
        display: flex;
        justify-content: space-between;
    }

    .button-left {
        display: flex;
        gap: 6px;
    }

    .button-right {
        display: flex;
        justify-content: flex-end;
        flex: 1;
    }
`;
    document.head.appendChild(style);

    let lastRightClickTime = 0;

    function extractBBSandKeyFromURL() {
        const pathParts = location.pathname.split('/').filter(Boolean);
        let bbs = '', key = '';
        if (pathParts.includes('read.cgi')) {
            const idx = pathParts.indexOf('read.cgi');
            bbs = pathParts[idx + 1] || '';
            key = pathParts[idx + 2] || '';
        }
        return { bbs, key };
    }

    function createFormbox() {
        const { bbs, key } = extractBBSandKeyFromURL();
        const sageChecked = localStorage.getItem('tmk_sage_checked') === 'true';
        const permanentChecked = localStorage.getItem('tmk_permanent_checked') === 'true'; // 常設の保存状態

        const wrapper = document.createElement('div');
        wrapper.innerHTML = `
        <div class="formbox" id="post_formbox">
            <div class="formheader" id="tmk_drag_handle">
                <div class="left">
                    レスを投稿する
                    <label class="sage-label">
                        <input type="checkbox" id="tmk_sage_checkbox" ${sageChecked ? 'checked' : ''}>
                        sage
                    </label>
                    <label class="permanent-label">
                        <input type="checkbox" id="tmk_permanent_checkbox" ${permanentChecked ? 'checked' : ''}>
                        常設
                    </label>
                </div>
                <button class="close-btn" id="tmk_close_btn">✖</button>
            </div>
            <div class="formbody">
                <form id="tmk_form">
                    <input placeholder="名前(省略可)" id="tmk_from" style="width:100%;">
                    <input placeholder="メールアドレス(省略可)" id="tmk_mail" style="width:100%;">
                    <textarea placeholder="コメント内容" id="tmk_message"></textarea>
                    <div class="button-row">
                        <div class="button-left">
                            <input class="submitbtn" type="submit" value="書き込む">
                            <input class="oekaki_load1" type="button" value="お絵描きLOAD">
                        </div>
                        <div class="button-right">
                            <input class="clearbtn" type="button" value="クリア" id="tmk_clear_btn">
                        </div>
                    </div>
                </form>
            </div>
        </div>`;
        const formbox = wrapper.firstElementChild;
        const mailInput = formbox.querySelector('#tmk_mail');
        const sageCheckbox = formbox.querySelector('#tmk_sage_checkbox');
        const permanentCheckbox = formbox.querySelector('#tmk_permanent_checkbox');

        if (sageCheckbox.checked) mailInput.value = 'sage';

        sageCheckbox.addEventListener('change', () => {
            mailInput.value = sageCheckbox.checked ? 'sage' : '';
            localStorage.setItem('tmk_sage_checked', sageCheckbox.checked);
        });

        permanentCheckbox.addEventListener('change', () => {
            localStorage.setItem('tmk_permanent_checked', permanentCheckbox.checked);
        });

        formbox.querySelector('#tmk_close_btn').addEventListener('click', () => {
            if (!permanentCheckbox.checked) {
                formbox.remove();
            }
        });

        formbox.querySelector('#tmk_clear_btn').addEventListener('click', () => {
            formbox.querySelector('#tmk_from').value = '';
            formbox.querySelector('#tmk_message').value = '';
            mailInput.value = sageCheckbox.checked ? 'sage' : '';
        });

        formbox.querySelector('#tmk_form').addEventListener('keydown', function (e) {
            if (e.ctrlKey && e.key === 'Enter') {
                e.preventDefault();
                formbox.querySelector('#tmk_form').dispatchEvent(new Event('submit', { cancelable: true, bubbles: true }));
            }
        });

        formbox.querySelector('#tmk_form').addEventListener('submit', function (e) {
            e.preventDefault();
            const iframe = document.querySelector('iframe[name="submit"], iframe#submit');
            if (!iframe || !iframe.contentDocument) {
                alert("投稿用のiframeが見つかりません");
                return;
            }

            try {
                const doc = iframe.contentDocument;
                const iframeForm = doc.querySelector('form');
                if (!iframeForm) {
                    alert("iframe内に投稿フォームが見つかりません");
                    return;
                }

                iframeForm.querySelector('input[name="FROM"]').value = formbox.querySelector('#tmk_from').value;
                iframeForm.querySelector('input[name="mail"]').value = formbox.querySelector('#tmk_mail').value;
                iframeForm.querySelector('textarea[name="MESSAGE"]').value = formbox.querySelector('#tmk_message').value;
                iframeForm.querySelector('input[name="time"]').value = Math.floor(Date.now() / 1000);

                // フォームを送信する
                HTMLFormElement.prototype.submit.call(iframeForm);

                // フォーム送信後にフォームボックスを削除、ただし常設チェック時は削除せずクリアだけ
                if (!permanentCheckbox.checked) {
                    formbox.remove();
                } else {
                    // 常設時でもフォームをクリア
                    formbox.querySelector('#tmk_clear_btn').click();
                }

                // 「sage」の状態を保存
                localStorage.setItem('tmk_sage_checked', sageCheckbox.checked);
            } catch (err) {
                console.error("iframe操作中にエラーが発生しました:", err);
                alert("投稿に失敗しました。iframeの読み込みがブロックされている可能性があります。");
            }
        });

        makeDraggable(formbox, formbox.querySelector('#tmk_drag_handle'));
        document.body.appendChild(formbox);
        formbox.querySelector('#tmk_message').focus();
    }

    window.createFormbox = createFormbox; // 関数をグローバルに共有

    function makeDraggable(el, handle) {
        let offsetX = 0, offsetY = 0, isDragging = false;

        handle.addEventListener('mousedown', function (e) {
            isDragging = true;
            offsetX = e.clientX - el.offsetLeft;
            offsetY = e.clientY - el.offsetTop;
            document.addEventListener('mousemove', onMouseMove);
            document.addEventListener('mouseup', onMouseUp);
            e.preventDefault();
        });

        function onMouseMove(e) {
            if (isDragging) {
                el.style.left = `${e.clientX - offsetX}px`;
                el.style.top = `${e.clientY - offsetY}px`;
                el.style.bottom = 'auto';
                el.style.transform = 'none';
            }
        }

        function onMouseUp() {
            isDragging = false;
            document.removeEventListener('mousemove', onMouseMove);
            document.removeEventListener('mouseup', onMouseUp);
        }
    }

    //純正右クリックメニュー表示を、Shift+右クリックに変更
    document.addEventListener('contextmenu', (e) => {
        if (!(e.shiftKey && e.button === 2)) {
            // Shift押しながら右クリック以外はメニュー表示キャンセル
            e.preventDefault();
        }
    });

    // ダブル右クリックでフォーム表示
    document.addEventListener('contextmenu', function (e) {
        const now = Date.now();
        if (now - lastRightClickTime < 300) {
            e.preventDefault();
            if (!document.querySelector('#post_formbox')) {
                createFormbox();
            }
        }
        lastRightClickTime = now;
    });

    // 右クリックしつつ左にドラッグでフォーム表示
    let rightClickDown = false;
    let startX = 0;
    const dragThreshold = 150; // 左にｎpx以上ドラッグでフォーム表示

    document.addEventListener('mousedown', (e) => {
        if (e.button === 2) { // 右クリック押したとき
            rightClickDown = true;
            startX = e.clientX;
        }
    });

    document.addEventListener('mouseup', (e) => {
        if (e.button === 2) {
            rightClickDown = false;
        }
    });

    document.addEventListener('mousemove', (e) => {
        if (rightClickDown) {
            if (startX - e.clientX > dragThreshold) {
                // 既にフォームがなければ表示
                if (!document.querySelector('#post_formbox')) {
                    createFormbox();
                }
                rightClickDown = false; // 1回だけ表示したら判定リセット
            }
        }
    });

})();
